<?php

namespace App\Exports;

use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;

class DailySalesExport implements FromCollection, WithHeadings, WithMapping
{
  private ?string $from;
  private ?string $to;

  public function __construct(Request $request)
  {
    $this->from = $request->query('from');
    $this->to = $request->query('to');
  }

  public function collection(): Collection
  {
    return DB::table('invoices')
      ->whereIn('status', ['paid', 'partial'])
      ->when($this->from, fn($q) => $q->whereDate('created_at', '>=', $this->from))
      ->when($this->to, fn($q) => $q->whereDate('created_at', '<=', $this->to))
      ->selectRaw('DATE(created_at) as date, COUNT(*) as invoices, SUM(total) as total')
      ->groupByRaw('DATE(created_at)')
      ->orderBy('date')
      ->get();
  }

  public function headings(): array
  {
    return ['date', 'invoices', 'total'];
  }

  public function map($row): array
  {
    return [$row->date, $row->invoices, $row->total];
  }
}
