<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Invoice extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_no',
        'customer_id',
        'subtotal',
        'discount_type',
        'discount_value',
        'discount_amount',
        'vat_percent',
        'vat_amount',
        'total',
        'paid_amount',
        'balance',
        'payment_method',
        'status',
        'client_ref',
        'issued_by',
        'bill_to_name',
        'bill_to_address',
        'payment_bank',
        'payment_name',
        'payment_account',
    ];

    public function items()
    {
        return $this->hasMany(InvoiceItem::class);
    }
}
