<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
       Schema::create('ledger_entries', function ($table) {
        $table->id();
        $table->foreignId('account_id')->constrained()->cascadeOnDelete();
        $table->decimal('debit', 14, 2)->default(0);
        $table->decimal('credit', 14, 2)->default(0);
        $table->string('reference_type'); // invoice, expense, payment, void
        $table->unsignedBigInteger('reference_id');
        $table->string('description')->nullable();
        $table->timestamps();

        $table->index(['reference_type','reference_id']);
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ledger_entries');
    }
};
