<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('products', function ($table) {
  $table->id();
  $table->string('name');
  $table->string('sku')->unique();
  $table->string('barcode')->nullable()->index();
  $table->decimal('cost_price', 14, 2)->default(0);
  $table->decimal('selling_price', 14, 2)->default(0);
  $table->integer('stock_qty')->default(0);
  $table->integer('low_stock_alert')->default(5);
  $table->boolean('is_active')->default(true);
  $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('products');
    }
};
