<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      Schema::create('invoices', function ($table) {
  $table->id();
  $table->string('invoice_no')->unique();
  $table->foreignId('customer_id')->nullable()->constrained()->nullOnDelete();
  $table->decimal('subtotal', 14, 2)->default(0);
  $table->enum('discount_type', ['none','percent','amount'])->default('none');
  $table->decimal('discount_value', 14, 2)->default(0);
  $table->decimal('discount_amount', 14, 2)->default(0);
  $table->decimal('vat_percent', 5, 2)->default(7.50);
  $table->decimal('vat_amount', 14, 2)->default(0);
  $table->decimal('total', 14, 2)->default(0);

  $table->decimal('paid_amount', 14, 2)->default(0);
  $table->decimal('balance', 14, 2)->default(0);

  $table->enum('payment_method', ['cash','transfer','pos','mixed'])->default('cash');
  $table->enum('status', ['paid','partial','unpaid','void'])->default('paid');

  $table->foreignId('issued_by')->constrained('users')->cascadeOnDelete();
  $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoices');
    }
};
