<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('invoice_items', function ($table) {
  $table->id();
  $table->foreignId('invoice_id')->constrained()->cascadeOnDelete();
  $table->foreignId('product_id')->nullable()->constrained()->nullOnDelete();

  $table->string('item_name');
  $table->string('sku')->nullable();
  $table->string('barcode')->nullable();

  $table->decimal('unit_price', 14, 2)->default(0);
  $table->decimal('cost_price', 14, 2)->default(0); // snapshot for COGS
  $table->integer('qty')->default(1);

  $table->decimal('line_discount', 14, 2)->default(0);
  $table->decimal('line_total', 14, 2)->default(0);

  $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('invoice_items');
    }
};
