<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->string('bill_to_name')->nullable();
            $table->text('bill_to_address')->nullable();
            $table->string('payment_bank')->nullable();
            $table->string('payment_name')->nullable();
            $table->string('payment_account')->nullable();
        });
    }

    public function down(): void
    {
        Schema::table('invoices', function (Blueprint $table) {
            $table->dropColumn([
                'bill_to_name',
                'bill_to_address',
                'payment_bank',
                'payment_name',
                'payment_account',
            ]);
        });
    }
};
