<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SettingsAndAccountsSeeder extends Seeder
{
  public function run(): void
  {
    DB::table('settings')->insert([
      'store_name' => 'Standard Global Technology and Renewables',
      'address' => '38 Atekong Drive, By Marian Road, Calabar',
      'phone' => '+234 702 652 9124',
      'vat_percent' => 7.50,
      'receipt_footer' => 'Thanks for your patronage',
      'created_at' => now(),
      'updated_at' => now(),
    ]);

    $accounts = [
      // Assets
      ['code'=>'1001','name'=>'Cash','type'=>'asset'],
      ['code'=>'1002','name'=>'Bank','type'=>'asset'],
      ['code'=>'1003','name'=>'Inventory','type'=>'asset'],
      ['code'=>'1004','name'=>'Accounts Receivable','type'=>'asset'],

      // Income
      ['code'=>'4001','name'=>'Sales Revenue','type'=>'income'],

      // Liabilities
      ['code'=>'2001','name'=>'VAT Payable','type'=>'liability'],

      // Expenses
      ['code'=>'5001','name'=>'Cost of Goods Sold (COGS)','type'=>'expense'],
      ['code'=>'6001','name'=>'Operating Expenses','type'=>'expense'],

      // Equity
      ['code'=>'3001','name'=>'Owner Capital','type'=>'equity'],
    ];

    foreach ($accounts as $a) {
      DB::table('accounts')->updateOrInsert(
        ['code' => $a['code']],
        array_merge($a, ['created_at'=>now(),'updated_at'=>now()])
      );
    }
  }
}
