<?php

use Illuminate\Http\Request;


use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\ProductController;
use App\Http\Controllers\Api\InvoiceController;
use App\Http\Controllers\Api\ExpenseController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\ReportController;
use App\Http\Controllers\Api\InventoryController;

Route::post('/auth/login', [AuthController::class, 'login']);
Route::middleware('auth:sanctum')->group(function () {
  Route::get('/me', [AuthController::class, 'me']);
  Route::post('/auth/logout', [AuthController::class, 'logout']);
  Route::get('/inventory/serial/{serial}', [InventoryController::class, 'lookupSerial']);
  Route::get('/products/lookup', [ProductController::class, 'lookup']);
  Route::get('/sync/products', [ProductController::class, 'sync']);
  Route::get('/reports/profit-loss', [ReportController::class, 'profitAndLoss']);
  Route::get('/reports/ledger', [ReportController::class, 'ledger']);
  Route::get('/reports/vat', [ReportController::class, 'vatReport']);
  Route::get('/reports/debtors', [ReportController::class, 'debtors']);
  Route::get('/reports/daily-sales', [ReportController::class, 'dailySales']);
  Route::get('/reports/daily-sales/excel', [ReportController::class, 'dailySalesExcel']);
  Route::get('/dashboard', [ReportController::class, 'dashboard']);

  Route::middleware('role:admin')->group(function () {
    Route::post('/close-month', [ReportController::class, 'closeMonth']);
    Route::get('/reports/pl/pdf', [ReportController::class, 'profitAndLossPdf']);
    Route::get('/inventory/summary', [InventoryController::class, 'summary']);
    Route::get('/inventory/products/list', [InventoryController::class, 'listProducts']);
    Route::get('/inventory/categories', [InventoryController::class, 'categories']);
    Route::post('/inventory/categories', [InventoryController::class, 'storeCategory']);
    Route::get('/inventory/products', [InventoryController::class, 'searchProducts']);
    Route::post('/inventory/products', [InventoryController::class, 'storeProduct']);
    Route::post('/inventory/products/{product}/items', [InventoryController::class, 'addItems']);
  });

  Route::middleware('role:cashier,admin')->group(function () {
    Route::post('/invoices', [InvoiceController::class, 'store']);
  });

  Route::middleware('role:admin')->group(function () {
    Route::get('/invoices', [InvoiceController::class, 'index']);
    Route::get('/invoices/{invoice}', [InvoiceController::class, 'show']);
    Route::patch('/invoices/{invoice}', [InvoiceController::class, 'update']);
    Route::delete('/invoices/{invoice}', [InvoiceController::class, 'destroy']);
    Route::post('/invoices/{invoice}/pay', [InvoiceController::class, 'applyPayment']);
  });

  Route::post('/expenses', [ExpenseController::class, 'store']);
});
